﻿// Render category dropdown
function renderTextHighlightsWidget(data, description) {
    $("#textHighlights").html(description);

    $("#CategoryName").keyup(function () {
        var value = ($("#CategoryName").val() != undefined && $("#CategoryName").val().trim() !== '') ? true : false;
        if (!value) {
            $("#selectedCategorySection").css({ display: 'none' });
            $("#CategoryName").css({ paddingLeft: '3px' });

        }
    })

    $("#CategoryName").a4autocomplete({
        data: data,
        labelProperty: "Category",
        valueProperty: "VariableId",
        altValueField: $("#VariableId"),
        required: true,
        render: {
            item: function (item) {
                return [
                    $("<div>").addClass("texthighlightCategorySection")
                        .append($("<label>").addClass("category-text").text(item.Category))
                ];
            }
        },
        select: function (event, ui) {
            // Display color on change of category dropdown
            var item = ui.item;
            selectedVariableId = item === undefined ? 0 : item.VariableId;
            var categoryColor = item === undefined ? "#FFFFFF" : item.Color;
            var variableName = item === undefined ? "" : item.VariableName;

            $("#categoryColors").css({ backgroundColor: categoryColor });
            $("#selectedCategorySection").css({ display: 'block', backgroundColor: categoryColor });
            $("#CategoryName").css({ paddingLeft: '27px' });
            a4.callServerMethod(a4.getSurveyAction("GetTextHighlightsResponseBasedonCategory", "TextHighlighter"), {
                variableName: variableName, questionId: selectedQuestionId, categoryColor: categoryColor, questionDescData: questionDescription
            }, function (response) {
                $("#textHighlights").html(response['QuestionDescWithColor']);
            });
        }
    })

    if (data != null) {
        let variableId = data.length == 0 ? 0 : data[0].VariableId;
        $("#CategoryName").a4autocomplete("setValue", variableId);
    } else { $("#CategoryName").a4autocomplete("setValue", 0); }
}

function enlargeTextHighlights() {
    var height = 500; var width = 800;
    var textForHighlights = $(".question-labels-container .text").text();

    modalDialog.showWindow(a4.getSurveyAction("TextHighlights", "TextHighlighter",
        { questionId: selectedQuestionId, textForHighlights: textForHighlights, language: textHighlightDashboardResults.surveyLanguage }), height, width, {
        afterClose: function () {
        }
    });
}